#ifndef _IndexDir_Cpp
#define _IndexDir_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <IO.H>
#include <Stdio.H>
#include <Stdlib.H> 	  

#include "../Headers/NSWFL.H"
#include "../Headers/IndexDir.H"

#include "../Dialogs/PackingDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FilePack::FreeMemory(void)
{
    unsigned long LoopCount = 0;

	while(LoopCount < FileCount)
    {
		free(FileNames[LoopCount]);
		FileNames[LoopCount] = NULL;
		LoopCount++;
	}

    FileNames = NULL;

    Allocs = 0;
    FileCount = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FilePack::Initialize(void)
{
    FileNames = NULL;

    Allocs = 0;
    FileCount = 0;

	if((FileNames = (char **) calloc(sizeof(char *), AllocIncrement + 1)) == NULL)
    {
        return false;
    }
    
    Allocs = AllocIncrement;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MakeRelativeRoot(char *inPath, char *outPath, int inPathLen, int inRootLen)
{
    int RPos = inRootLen;
    int WPos = 0;
    
    while(RPos < inPathLen)
    {
        outPath[WPos] = inPath[RPos];
        RPos++;
        WPos++;
    }

    outPath[WPos] = '\0';

    return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FilePack::IndexDirectory(char *inFolder, int RootLen)
{
	WIN32_FIND_DATA FindData;
	HANDLE FileHandle;

	int Found = 0;
	int NeededMemory = 0;

	DWORD LocalLoop = 0;

	char DirTemp[257];
	char StatusText[1024];

	sprintf(DirTemp, "%s\\%s", inFolder, "*.*");
	FileHandle = FindFirstFile(DirTemp,&FindData);
	Found = (int) FileHandle;

    int DirLen = strlen(inFolder);

	while(Found != 0)
	{
		if( strcmp(FindData.cFileName, ".") && strcmp(FindData.cFileName, "..") )
		{
			if(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
                sprintf(DirTemp, "%s\\%s", inFolder, FindData.cFileName);

                sprintf(StatusText, "Searching: %s", FindData.cFileName);
                Set_Text(PackingStatusText_hWnd, StatusText);

                if(!IndexDirectory(DirTemp, RootLen))
                {
                    return false;
                }
			}
			else {
                if(FileCount == Allocs)
                {
                    FileNames = (char **) realloc(FileNames, ((Allocs * sizeof(char *)) + (AllocIncrement * sizeof(char *))) + 1);
                    Allocs = (Allocs + AllocIncrement);
                }

				NeededMemory = strlen(FindData.cFileName) + (DirLen - RootLen) + 10;
				FileNames[FileCount] = (char *) calloc(NeededMemory, 1);

                MakeRelativeRoot(inFolder, DirTemp, DirLen, RootLen);

				sprintf(FileNames[FileCount], "%s\\%s", DirTemp, FindData.cFileName);

				FileCount++;
			}
		}

		Found = FindNextFile(FileHandle, &FindData);
	}
	FindClose(FileHandle);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
